%% Analysis code for:
% "The human cerebellum is essential for modulating perceptual sensitivity
% based on temporal expectations"
% by Assaf Breska and Rich Ivry
%
% assaf.breska@berkeley.edu


dataAll=xlsread('RIC_percep_dataAll.xlsx',1); % read data file

dpResultsAll=zeros(25,10);
for sub=1:25
    
    subData=dataAll(dataAll(:,1)==sub, :); % take current subject data
    
    subData=subData(subData(:,8)~=0,:); % remove catch trials where no response was collected
    
    % remove block pairs in which acc in valid trials was too high/too low
    for b=2:2:8
        
        currentBlocksValidsData=subData((subData(:,3)==b | subData(:,3)==b-1) & subData(:,8)==1, [9 10]); % take valid trials of block pair
        currBlocksAcc=mean(currentBlocksValidsData(:,1)==currentBlocksValidsData(:,2)); % get accuracy
        
        if currBlocksAcc>0.99 || currBlocksAcc<0.6
            subData((subData(:,3)==b | subData(:,3)==b-1),:)=[]; % eliminate trials
        end
    end
    
    subDataDP=[sub, subData(1,2)];
    for condition=[1 2] % rhythm, interval
        for cueInterval=[1 2] % short, long
            for targetValidity=[1 2] % valid, invalid
                
                % get current condition data
                condData=subData(subData(:,5)==condition & subData(:,7)==cueInterval & subData(:,8)==targetValidity, [9 10]);
                
                % calculate dprime
                hit=sum(condData(:,1)==1 & condData(:,2)==1)/sum(condData(:,1)==1);
                FA=sum(condData(:,1)==0 & condData(:,2)==1)/sum(condData(:,1)==0);
 
                if hit==1 % correction for extreme values
                    hit=(sum(condData(:,1)==1)-0.5)/sum(condData(:,1)==1);
                elseif hit==0
                    hit=0.5/sum(condData(:,1)==1);
                end
                
                if FA==1
                    FA=(sum(condData(:,1)==0)-0.5)/sum(condData(:,1)==0);
                elseif FA==0
                    FA=0.5/sum(condData(:,1)==0);
                end
                
                dP=icdf('Normal', hit, 0,1)-icdf('Normal', FA, 0,1); % dprime
                subDataDP=[subDataDP, dP];
            end            
        end        
    end
    dpResultsAll(sub,:)=subDataDP;
end

% validity effect ttests
[~,p1, ~, st1]=ttest(dpResultsAll(dpResultsAll(:,2)==1,3)-dpResultsAll(dpResultsAll(:,2)==1,4));
[~,p2, ~, st2]=ttest(dpResultsAll(dpResultsAll(:,2)==1,7)-dpResultsAll(dpResultsAll(:,2)==1,8));
disp(['Patients: Rhythm, t=' num2str(st1.tstat,3) ', p=' num2str(p1,3) '; interval, t=' num2str(st2.tstat,3) ', p=' num2str(p2,3)]);

[~,p1, ~, st1]=ttest(dpResultsAll(dpResultsAll(:,2)==0,3)-dpResultsAll(dpResultsAll(:,2)==0,4));
[~,p2, ~, st2]=ttest(dpResultsAll(dpResultsAll(:,2)==0,7)-dpResultsAll(dpResultsAll(:,2)==0,8));
disp(['Controls: Rhythm, t=' num2str(st1.tstat,3) ', p=' num2str(p1,3) '; interval, t=' num2str(st2.tstat,3) ', p=' num2str(p2,3)]);


% prepare data for R
dataRlong=reshape(dpResultsAll(:,3:10)', numel(dpResultsAll(:,3:10)), 1);
designSingleSub=[kron([1 2], [1 1 1 1])' [kron([1 2], [1 1])';  kron([1 2], [1 1])'] repmat([1;2], 4, 1)];
dataRlong=[kron(dpResultsAll(:,1)', ones(1,8))' kron(dpResultsAll(:,2)', ones(1,8))' repmat(designSingleSub, size(dpResultsAll,1), 1), dataRlong];
delete('data_RICperceptual_forR.xlsx')
xlswrite('data_RICperceptual_forR.xlsx', dataRlong)


%% for figure 2 - short target interval

meansSubsDPp=dpResultsAll(dpResultsAll(:,2)==1,3:10);
meansSubsDPc=dpResultsAll(dpResultsAll(:,2)==0,3:10);
meanP=mean(meansSubsDPp);
meanC=mean(meansSubsDPc);
stdsMeansP=std(meansSubsDPp(:,[1:2:end])-meansSubsDPp(:,[2:2:end]))/sqrt(size(meansSubsDPp,1));
stdsMeansC=std(meansSubsDPc(:,[1:2:end])-meansSubsDPc(:,[2:2:end]))/sqrt(size(meansSubsDPc,1));

lineCol=[0.2 0.2 0.2];
valColor=[0.4 0.7 0.4];
invalColor=[.7 0.4 .7];

% interval
figure('Position', [100 100 300 220]);    
b=bar(reshape([meanP([5 6]) meanC([5 6])],2,2)'); hold on; box off
b(1).FaceColor=valColor; b(2).FaceColor=invalColor;
b(1).EdgeColor=valColor; b(2).EdgeColor=invalColor;

line([0.8 1.2; 0.8 1.2], [meanP([5 6])-stdsMeansP(3); meanP([5 6])+stdsMeansP(3)], 'Color', [0 0 0], 'LineWidth', 2)
line([1.8 2.2; 1.8 2.2], [meanC([5 6])-stdsMeansC(3); meanC([5 6])+stdsMeansC(3)], 'Color', [0 0 0], 'LineWidth', 2)
plot([0.85 1.15], meansSubsDPp(:,[5 6])', 'Color', lineCol); 
plot([1.85 2.15], meansSubsDPc(:,[5 6])', 'Color', lineCol)
axis([0.5 2.5 0 4]); set(gca, 'XTick', [1 2], 'XTickLabel', {[],[]}, 'FontSize', 12);

% rhythm
figure('Position', [400 100 300 220]);   
b=bar(reshape([meanP([1 2]) meanC([1 2])],2,2)'); hold on; box off
b(1).FaceColor=valColor; b(2).FaceColor=invalColor;
b(1).EdgeColor=valColor; b(2).EdgeColor=invalColor;

line([0.8 1.2; 0.8 1.2], [meanP([1 2])-stdsMeansP(1); meanP([1 2])+stdsMeansP(1)], 'Color', [0 0 0], 'LineWidth', 2)
line([1.8 2.2; 1.8 2.2], [meanC([1 2])-stdsMeansC(1); meanC([1 2])+stdsMeansC(1)], 'Color', [0 0 0], 'LineWidth', 2)
plot([0.85 1.15], meansSubsDPp(:,[1 2])', 'Color', lineCol);
plot([1.85 2.15], meansSubsDPc(:,[1 2])', 'Color', lineCol)
axis([0.5 2.5 0 4]); set(gca, 'XTick', [1 2], 'XTickLabel', {[],[]}, 'FontSize', 12);
  

%% for supplementary figure - long target interval

meansSubsDPp=dpResultsAll(dpResultsAll(:,2)==1,3:10);
meansSubsDPc=dpResultsAll(dpResultsAll(:,2)==0,3:10);
meanP=mean(meansSubsDPp);
meanC=mean(meansSubsDPc);
stdsMeansP=std(meansSubsDPp(:,[1:2:end])-meansSubsDPp(:,[2:2:end]))/sqrt(size(meansSubsDPp,1));
stdsMeansC=std(meansSubsDPc(:,[1:2:end])-meansSubsDPc(:,[2:2:end]))/sqrt(size(meansSubsDPc,1));

lineCol=[0.2 0.2 0.2];
valColor=[0.4 0.7 0.4];
invalColor=[.7 0.4 .7];

% interval
figure('Position', [100 500 300 220]);    
b=bar(reshape([meanP([7 8]) meanC([7 8])],2,2)'); hold on; box off
b(1).FaceColor=valColor; b(2).FaceColor=invalColor;
b(1).EdgeColor=valColor; b(2).EdgeColor=invalColor;

line([0.8 1.2; 0.8 1.2], [meanP([7 8])-stdsMeansP(4); meanP([7 8])+stdsMeansP(4)], 'Color', [0 0 0], 'LineWidth', 2)
line([1.8 2.2; 1.8 2.2], [meanC([7 8])-stdsMeansC(4); meanC([7 8])+stdsMeansC(4)], 'Color', [0 0 0], 'LineWidth', 2)
plot([0.85 1.15], meansSubsDPp(:,[7 8])', 'Color', lineCol); 
plot([1.85 2.15], meansSubsDPc(:,[7 8])', 'Color', lineCol)
axis([0.5 2.5 0 4]); set(gca, 'XTick', [1 2], 'XTickLabel', {[],[]}, 'FontSize', 12);

% rhythm
figure('Position', [400 500 300 220]);   
b=bar(reshape([meanP([3 4]) meanC([3 4])],2,2)'); hold on; box off
b(1).FaceColor=valColor; b(2).FaceColor=invalColor;
b(1).EdgeColor=valColor; b(2).EdgeColor=invalColor;

line([0.8 1.2; 0.8 1.2], [meanP([3 4])-stdsMeansP(2); meanP([3 4])+stdsMeansP(2)], 'Color', [0 0 0], 'LineWidth', 2)
line([1.8 2.2; 1.8 2.2], [meanC([3 4])-stdsMeansC(2); meanC([3 4])+stdsMeansC(2)], 'Color', [0 0 0], 'LineWidth', 2)
plot([0.85 1.15], meansSubsDPp(:,[3 4])', 'Color', lineCol);
plot([1.85 2.15], meansSubsDPc(:,[3 4])', 'Color', lineCol)
axis([0.5 2.5 0 4]); set(gca, 'XTick', [1 2], 'XTickLabel', {[],[]}, 'FontSize', 12);
  

[~,p1, ~, st1]=ttest(dpResultsAll(dpResultsAll(:,2)==1,5)-dpResultsAll(dpResultsAll(:,2)==1,6));
[~,p2, ~, st2]=ttest(dpResultsAll(dpResultsAll(:,2)==1,9)-dpResultsAll(dpResultsAll(:,2)==1,10));
disp(['Patients: Rhythm, t=' num2str(st1.tstat,3) ', p=' num2str(p1,2) '; interval, t=' num2str(st2.tstat,3) ', p=' num2str(p2,2)]);

[~,p1, ~, st1]=ttest(dpResultsAll(dpResultsAll(:,2)==0,5)-dpResultsAll(dpResultsAll(:,2)==0,6));
[~,p2, ~, st2]=ttest(dpResultsAll(dpResultsAll(:,2)==0,9)-dpResultsAll(dpResultsAll(:,2)==0,10));
disp(['Controls: Rhythm, t=' num2str(st1.tstat,3) ', p=' num2str(p1,2) '; interval, t=' num2str(st2.tstat,3) ', p=' num2str(p2,2)]);

%%
